/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.xml;

import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.hamcrest.xml.HasXPath;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasXPathTest
extends AbstractMatcherTest {
    private Document xml;
    private NamespaceContext ns;

    protected void setUp() throws Exception {
        super.setUp();
        this.xml = HasXPathTest.parse("<root type='food'>\n  <something id='a'><cheese>Edam</cheese></something>\n  <something id='b'><cheese>Cheddar</cheese></something>\n  <f:foreignSomething xmlns:f=\"http://cheese.com\" milk=\"camel\">Caravane</f:foreignSomething>\n  <emptySomething />\n  <f:emptySomething xmlns:f=\"http://cheese.com\" /></root>\n");
        this.ns = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return "cheese".equals(prefix) ? "http://cheese.com" : null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return "http://cheese.com".equals(namespaceURI) ? "cheese" : null;
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                HashSet<String> prefixes = new HashSet<String>();
                String prefix = this.getPrefix(namespaceURI);
                if (prefix != null) {
                    prefixes.add(prefix);
                }
                return prefixes.iterator();
            }
        };
    }

    @Override
    protected Matcher<?> createMatcher() {
        return HasXPath.hasXPath((String)"//irrelevant");
    }

    public void testAppliesMatcherToXPathInDocument() throws Exception {
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"/root/something[2]/cheese", (Matcher)IsEqual.equalTo((Object)"Cheddar")));
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"//something[1]/cheese", (Matcher)StringContains.containsString((String)"dam")));
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"//something[2]/cheese", (Matcher)IsNot.not((Matcher)StringContains.containsString((String)"dam"))));
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"/root/@type", (Matcher)IsEqual.equalTo((Object)"food")));
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"//something[@id='b']/cheese", (Matcher)IsEqual.equalTo((Object)"Cheddar")));
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"//something[@id='b']/cheese"));
    }

    public void testMatchesEmptyElement() throws Exception {
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"//emptySomething"));
    }

    public void testMatchesEmptyElementInNamespace() throws Exception {
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"//cheese:emptySomething", (NamespaceContext)this.ns));
    }

    public void testFailsIfNodeIsMissing() throws Exception {
        MatcherAssert.assertThat((Object)this.xml, (Matcher)IsNot.not((Matcher)HasXPath.hasXPath((String)"/root/something[3]/cheese", (NamespaceContext)this.ns, (Matcher)IsEqual.equalTo((Object)"Cheddar"))));
        MatcherAssert.assertThat((Object)this.xml, (Matcher)IsNot.not((Matcher)HasXPath.hasXPath((String)"//something[@id='c']/cheese", (NamespaceContext)this.ns)));
    }

    public void testFailsIfNodeIsMissingInNamespace() throws Exception {
        MatcherAssert.assertThat((Object)this.xml, (Matcher)IsNot.not((Matcher)HasXPath.hasXPath((String)"//cheese:foreignSomething", (Matcher)IsEqual.equalTo((Object)"Badger"))));
        MatcherAssert.assertThat((Object)this.xml, (Matcher)IsNot.not((Matcher)HasXPath.hasXPath((String)"//cheese:foreignSomething")));
    }

    public void testMatchesWithNamespace() throws Exception {
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"//cheese:foreignSomething", (NamespaceContext)this.ns));
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"//cheese:foreignSomething/@milk", (NamespaceContext)this.ns, (Matcher)IsEqual.equalTo((Object)"camel")));
        MatcherAssert.assertThat((Object)this.xml, (Matcher)HasXPath.hasXPath((String)"//cheese:foreignSomething/text()", (NamespaceContext)this.ns, (Matcher)IsEqual.equalTo((Object)"Caravane")));
    }

    public void testThrowsIllegalArgumentExceptionIfGivenIllegalExpression() {
        try {
            HasXPath.hasXPath((String)"\\g:dfgd::DSgf/root/something[2]/cheese", (Matcher)IsEqual.equalTo((Object)"blah"));
            HasXPathTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDescribesItself() throws Exception {
        HasXPathTest.assertDescription("an XML document with XPath /some/path \"Cheddar\"", HasXPath.hasXPath((String)"/some/path", (Matcher)IsEqual.equalTo((Object)"Cheddar")));
        HasXPathTest.assertDescription("an XML document with XPath /some/path", HasXPath.hasXPath((String)"/some/path"));
    }

    public void testDescribesMissingNodeMismatch() {
        HasXPathTest.assertMismatchDescription("xpath returned no results.", HasXPath.hasXPath((String)"//honky"), this.xml);
    }

    public void testDescribesIncorrectNodeValueMismatch() {
        HasXPathTest.assertMismatchDescription("was \"Edam\"", HasXPath.hasXPath((String)"//something[1]/cheese", (Matcher)IsEqual.equalTo((Object)"parmesan")), this.xml);
    }

    private static Document parse(String xml) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(xml.getBytes()));
    }
}

